package jadean.dean.java.resourceparser.classparser;

import jadean.dean.java.JavaResource;
import jadean.dean.java.resourceparser.JavaResourceFilter;

public class ClassResourceFilter implements JavaResourceFilter {

	private String baseFile;
	
	public ClassResourceFilter(String baseFile) {
		this.baseFile = baseFile;
	}
	
	public boolean accept(JavaResource resource) {
		return (!resource.getName().equals(this.baseFile)) &&
			   (!resource.getName().startsWith("java.lang.")) &&
			   (!resource.getName().equals("")) &&
			   (!resource.getName().contains("$"));
	}

}
